<?php
	$docs = getDocumentosPorCliente($_SESSION['cliente.id'], '', 1, 999, $totalRegistros);
	$usernames = array(); 
	foreach ($docs as $user) {    $usernames[] = $user['fecha'];}
	
	array_multisort($usernames, SORT_ASC, $docs);
	
?>

		<!-- BREADCRUMBS -->
		<section class="breadcrumb parallax margbot30" style="background-position: 50% 0px;"></section>
		<!-- //BREADCRUMBS -->	
		
		<!-- PAGE HEADER -->
		<section class="page_header">
			
			<!-- CONTAINER -->
			<div class="container">
				<h3 class="pull-left"><b>Estado de Cuenta</b></h3>
				
				<div class="pull-right">
					<a href="javascript:history.go(-1)">... P&aacute;gina Anterior<i class="fa fa-angle-right"></i></a>
				</div>
			</div><!-- //CONTAINER -->
		</section><!-- //PAGE HEADER -->
		
		<!-- TOVAR DETAILS -->
		<section class="tovar_details padbot70">
			
			<!-- CONTAINER -->
			<div class="container">
			
				<!-- ROW -->
				<div class="row">
					<div class="col-lg-12 col-md-12 col-sm-12 padbot60">
						
						<?php
						if(count($docs)==0){
						?>
						
						<div class="title center">
							<h3>Estado de Cuenta</h3>
							<p>No hay documentos.</p>
						</div>
						
						<?php
						}else{
						?>
						
						<div class="title center">
							<h3>Estado de Cuenta</h3>
							<p>Aqu&iacute; encontrar&aacute; el detalle de su estado de su cuenta.</p>
						</div>
						
					</div>
					
				</div><!-- //ROW -->
		
				<!-- ROW -->
				<div class="row">
		
					<div class="col-lg-12 col-md-12 col-sm-12 padbot60">
						<table class="table type1">
							<thead>
								<tr>
									<th>Fecha</th>
									<th>Tipo</th>
									<th>C&oacute;digo</th>
									<th>Moneda</th>
									<th>Monto</th>
									<th>Saldo</th>
								</tr>
							</thead>
							<tbody>
								<?php
								$saldo = []; $monedas = [];
								foreach($docs as $doc){
									if (empty($monedas)){
										$monedas[$doc['moneda']] = $doc['moneda'];
										$saldo[$doc['moneda']] = 0;
									}
									$saldo[$doc['moneda']] += $doc['total'] * $doc['debito_credito'];
								?>
								<tr>
									<td><?php echo date_format(date_create_from_format('Y-m-d H:i:s', $doc['fecha']), 'd/m/Y'); ?></td>
									<td><?php echo $doc['tipo']; ?></td>
									<td><?php echo $doc['codigo']; ?></td>
									<td><?php echo $doc['moneda']; ?></td>
									<td><?php echo number_format($doc['total'],2,",","."); ?></td>
									<td><b><?php foreach($saldo as $k=>$v) echo $k .' '. number_format($v,2,",",".") . "<br>"; ?></b></td>
								</tr>
								<?php } ?>
							</tbody>
						</table>
					</div>
					
				</div><!-- //ROW -->
				<?php } ?>
			
			</div><!-- //CONTAINER -->
		</section><!-- //TOVAR DETAILS -->
			
